/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import com.jhlabs.awt.Alignment;
import com.jhlabs.awt.ConstraintLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public class StackLayout
extends ConstraintLayout {
    private static final Integer DEFAULT = new Integer(0);

    public static Integer alignment(int n, int n2) {
        return new Integer(n << 8 | n2);
    }

    public void setConstraint(Component component, Object object) {
        if (object == null) {
            object = DEFAULT;
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException("Constraint must be an Integer");
        }
        super.setConstraint(component, object);
    }

    public void measureLayout(Container container, Dimension dimension, int n) {
        int n2 = container.getComponentCount();
        if (dimension != null) {
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = this.getComponentSize(component, n);
                dimension.width = Math.max(dimension2.width, dimension.width);
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
        } else {
            Insets insets = container.getInsets();
            Dimension dimension3 = container.getSize();
            int n3 = dimension3.width - (insets.left + insets.right);
            int n4 = dimension3.height - (insets.top + insets.bottom);
            Rectangle rectangle = new Rectangle(insets.left, insets.top, n3, n4);
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                int n5 = (Integer)this.getConstraint(component);
                int n6 = n5 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                if (!component.isVisible()) continue;
                Dimension dimension4 = this.getComponentSize(component, n);
                Rectangle rectangle2 = new Rectangle(0, 0, dimension4.width, dimension4.height);
                Alignment.alignInCell(rectangle2, rectangle, n6, n7);
                component.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
    }
}

