/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.io.File;
import java.io.Serializable;

public class FileName
implements Serializable,
Comparable {
    private String fullFn;
    private String fileDir;
    private String fileNm;
    private String fileExt;
    private String fileExtWithDot;

    public FileName(String string) {
        this.fullFn = string;
        int n = this.fullFn.lastIndexOf(File.separatorChar);
        if (n != -1) {
            this.fileDir = this.fullFn.substring(0, 1 + n);
            this.fileNm = this.fullFn.substring(1 + n);
        } else {
            this.fileDir = "";
            this.fileNm = this.fullFn;
        }
        n = this.fileNm.lastIndexOf(".");
        if (n != -1 && n != this.fileNm.length()) {
            this.fileExt = this.fileNm.substring(n + 1);
            this.fileNm = this.fileNm.substring(0, n);
        } else {
            this.fileExt = "";
        }
        this.fileExtWithDot = n != -1 ? "." + this.fileExt : "";
    }

    public String getFilename() {
        return this.fullFn;
    }

    public String getDir() {
        return this.fileDir;
    }

    public String getName() {
        return this.fileNm;
    }

    public String getExt() {
        return this.fileExt;
    }

    public String getExtWithDot() {
        return this.fileExtWithDot;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof FileName)) {
            throw new ClassCastException("FileName: Invalid object being compared.");
        }
        String string = this.toString();
        String string2 = object.toString();
        return string.compareTo(string2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof FileName) {
            try {
                bl = this.compareTo(object) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public String toString() {
        return this.getFilename();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java FileName <somefilenamepath>");
        } else {
            FileName fileName = new FileName(stringArray[0]);
            System.out.println("File name: (" + fileName.getFilename() + ")");
            System.out.println("  Dir....: '" + fileName.getDir() + "'");
            System.out.println("  Name...: '" + fileName.getName() + "'");
            System.out.println("  Ext....: '" + fileName.getExt() + "'");
            System.out.println("  Ext w/.: '" + fileName.getExtWithDot() + "'");
        }
    }
}

