/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

class ImageIconProxy
implements Icon {
    private Icon realIcon = null;
    private String imageName;
    private int width;
    private int height;
    boolean isIconCreated = false;

    public ImageIconProxy(String string, int n, int n2) {
        this.imageName = string;
        this.width = n;
        this.height = n2;
    }

    public int getIconHeight() {
        return this.isIconCreated ? this.height : this.realIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.isIconCreated ? this.width : this.realIcon.getIconWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(final Component component, Graphics graphics, int n, int n2) {
        if (this.isIconCreated) {
            this.realIcon.paintIcon(component, graphics, n, n2);
        } else {
            graphics.drawRect(n, n2, this.width - 1, this.height - 1);
            graphics.drawString("Loading image...", n + 20, n2 + 20);
            ImageIconProxy imageIconProxy = this;
            synchronized (imageIconProxy) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            ImageIconProxy.this.realIcon = new ImageIcon(ImageIconProxy.this.imageName);
                            ImageIconProxy.this.isIconCreated = true;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        component.repaint();
                    }
                });
            }
        }
    }
}

