/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IniFile {
    private HashMap sectionMap = new HashMap();

    public IniFile(String string) throws IOException {
        this(new File(string));
    }

    public IniFile(File file) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        Section section = new Section("Defaults");
        String string = lineNumberReader.readLine();
        while (string != null) {
            if (!"".equals(string = string.trim()) && !string.startsWith("#")) {
                Object object;
                if (string.startsWith("[") && string.endsWith("]")) {
                    object = string.substring(1, string.length() - 1).trim();
                    section = new Section((String)object);
                    this.sectionMap.put(object, section);
                } else {
                    if (string.startsWith("[")) {
                        throw new IOException("syntax error at line " + lineNumberReader.getLineNumber());
                    }
                    object = new Tokenizer(string);
                    String string2 = ((Tokenizer)object).getToken();
                    if (!"=".equals(((Tokenizer)object).getToken())) {
                        throw new IOException("syntax error at line " + lineNumberReader.getLineNumber());
                    }
                    String string3 = ((Tokenizer)object).getToken();
                    while ((string = ((Tokenizer)object).getToken()) != null) {
                        string3 = string3 + " " + object;
                    }
                    section.put(string2, string3);
                }
            }
            string = lineNumberReader.readLine();
        }
        lineNumberReader.close();
    }

    public Set sections() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.sectionMap.values());
        return hashSet;
    }

    public Section getSection(String string) {
        return (Section)this.sectionMap.get(string);
    }

    public static void main(String[] stringArray) throws Exception {
        IniFile iniFile = new IniFile(new File(stringArray[0]));
        Set set = iniFile.sections();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            System.out.println("[" + section.getName() + "]");
            Map map = section.getMap();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                System.out.println("  " + string + " = " + map.get(string));
            }
        }
    }

    public static class Section {
        private String name;
        private HashMap map;

        private Section() {
        }

        private Section(String string) {
            this.name = string;
            this.map = new HashMap();
        }

        private void put(String string, String string2) {
            this.map.put(string, string2);
        }

        public String getName() {
            return this.name;
        }

        public Map getMap() {
            return (Map)this.map.clone();
        }

        public Properties getProperties() {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.map);
            return properties;
        }

        public String get(String string) {
            return (String)this.map.get(string);
        }

        public Set getKeys() {
            return this.map.keySet();
        }
    }

    private static class Tokenizer {
        private String s;
        private int ix;
        private int end;

        private Tokenizer(String string) {
            this.s = string;
            this.ix = 0;
            this.end = string.indexOf(35);
            if (this.end == -1) {
                this.end = string.length();
            }
        }

        private String getToken() {
            while (this.ix < this.end && Character.isWhitespace(this.s.charAt(this.ix))) {
                ++this.ix;
            }
            if (this.ix < this.end && this.s.charAt(this.ix) == '=') {
                ++this.ix;
                return "=";
            }
            int n = this.ix;
            while (this.ix < this.end && !Character.isWhitespace(this.s.charAt(this.ix)) && this.s.charAt(this.ix) != '=') {
                ++this.ix;
            }
            return n == this.ix ? null : this.s.substring(n, this.ix);
        }
    }
}

