/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class PriorityQueue
extends AbstractList
implements Serializable {
    private static final int DEFAULT_PRIORITY_COUNT = 10;
    private static final int DEFAULT_PRIORITY = 0;
    private List[] queue;

    public PriorityQueue() {
        this(10);
    }

    public PriorityQueue(Collection collection) {
        this(collection, 10);
    }

    public PriorityQueue(int n) {
        this(null, n);
    }

    public PriorityQueue(Collection collection, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal priority count: " + n);
        }
        this.queue = new List[n];
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public boolean add(Object object) {
        this.insert(object, 0);
        return true;
    }

    public void insert(Object object, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal priority: " + n);
        }
        if (this.queue[n] == null) {
            this.queue[n] = new LinkedList();
        }
        this.queue[n].add(object);
        ++this.modCount;
    }

    public Object getFirst() {
        return this.iterator().next();
    }

    public Object get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal index: " + n);
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 == n) {
                return iterator.next();
            }
            ++n2;
        }
        return null;
    }

    public void clear() {
        int n = this.queue.length;
        for (int i = 0; i < n; ++i) {
            this.queue[i].clear();
        }
    }

    public Object removeFirst() {
        Iterator iterator = this.iterator();
        Object e = iterator.next();
        iterator.remove();
        return e;
    }

    public int size() {
        int n = 0;
        int n2 = this.queue.length;
        for (int i = 0; i < n2; ++i) {
            if (this.queue[i] == null) continue;
            n += this.queue[i].size();
        }
        return n;
    }

    public Iterator iterator() {
        Iterator iterator = new Iterator(){
            int expectedModCount;
            int priority;
            int count;
            int size;
            int lastRet;
            Iterator tempIter;
            {
                this.expectedModCount = PriorityQueue.this.modCount;
                this.priority = PriorityQueue.this.queue.length - 1;
                this.count = 0;
                this.size = PriorityQueue.this.size();
                this.lastRet = -1;
                this.tempIter = PriorityQueue.this.queue[this.priority] == null ? null : PriorityQueue.this.queue[this.priority].iterator();
            }

            private final void checkForComodification() {
                if (PriorityQueue.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public boolean hasNext() {
                return this.count != PriorityQueue.this.size();
            }

            public Object next() {
                while (true) {
                    if (this.tempIter != null && this.tempIter.hasNext()) {
                        Object e = this.tempIter.next();
                        this.checkForComodification();
                        this.lastRet = this.count++;
                        return e;
                    }
                    if (--this.priority < 0) {
                        this.checkForComodification();
                        throw new NoSuchElementException();
                    }
                    if (PriorityQueue.this.queue[this.priority] == null) {
                        this.tempIter = null;
                        continue;
                    }
                    this.tempIter = PriorityQueue.this.queue[this.priority].iterator();
                }
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                this.tempIter.remove();
                --this.count;
                this.lastRet = -1;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
        };
        return iterator;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = n = this.queue.length - 1; i >= 0; --i) {
            if (i != n) {
                stringBuffer.append(",");
            }
            stringBuffer.append(i + ":");
            if (this.queue[i] == null || this.queue[i].size() <= 0) continue;
            stringBuffer.append(this.queue[i].toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        PriorityQueue priorityQueue = new PriorityQueue(list);
        System.out.println(priorityQueue);
        priorityQueue = new PriorityQueue(10);
        try {
            System.out.println(priorityQueue.removeFirst());
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Received expected exception");
        }
        priorityQueue.insert("Joy", 8);
        priorityQueue.insert("Scott", 9);
        priorityQueue.insert("Sueltz", 5);
        priorityQueue.insert("Bill", 8);
        priorityQueue.insert("McNealy", 9);
        priorityQueue.insert("Patricia", 5);
        priorityQueue.insert("C.", 5);
        priorityQueue.insert("Papadopoulos", 4);
        priorityQueue.insert("Greg", 4);
        System.out.println(priorityQueue);
        priorityQueue.addAll(list);
        System.out.println(priorityQueue);
        while (priorityQueue.size() != 0) {
            System.out.println(priorityQueue.removeFirst());
        }
    }
}

