/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JButton;
import javax.swing.JFrame;

public class RoundButton
extends JButton {
    private Color highlightColor = Color.lightGray;
    Shape shape;

    public RoundButton(String string) {
        super(string);
        Dimension dimension = this.getPreferredSize();
        dimension.width = dimension.height = Math.max(dimension.width, dimension.height);
        this.setPreferredSize(dimension);
        this.setContentAreaFilled(false);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.getModel().isArmed()) {
            graphics.setColor(this.highlightColor);
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillOval(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        super.paintComponent(graphics);
    }

    protected void paintBorder(Graphics graphics) {
        graphics.setColor(this.getForeground());
        graphics.drawOval(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public boolean contains(int n, int n2) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new Ellipse2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        return this.shape.contains(n, n2);
    }

    public static void main(String[] stringArray) {
        RoundButton roundButton = new RoundButton("Jackpot");
        roundButton.setBackground(Color.green);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setBackground(Color.yellow);
        jFrame.getContentPane().add(roundButton);
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.setSize(150, 150);
        jFrame.setVisible(true);
    }
}

