/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.swing.JFrame;

public class Utilities {
    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isEmptyString(String string) {
        return "".equals(string);
    }

    public static boolean isEmptyOrNull(String string) {
        return Utilities.isNull(string) || Utilities.isEmptyString(string);
    }

    public static Image loadImage(Object object, Toolkit toolkit, String string, String string2) {
        Image image = null;
        try {
            String string3 = string + string2;
            InputStream inputStream = object.getClass().getResourceAsStream(string3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            do {
                if ((n = bufferedInputStream.read()) == -1) continue;
                byteArrayOutputStream.write(n);
            } while (n != -1);
            bufferedInputStream.close();
            image = toolkit.createImage(byteArrayOutputStream.toByteArray());
            if (image == null) {
                System.err.println("loadImage() - Image failed to load: " + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public static void centerDialog(Window window, Dialog dialog) {
        if (window != null && dialog != null) {
            Dimension dimension = window.getSize();
            Dimension dimension2 = dialog.getSize();
            Point point = window.getLocation();
            if (dimension.width > dimension2.width && dimension.height > dimension2.height) {
                int n = point.x + (dimension.width - dimension2.width) / 2;
                int n2 = point.y + (dimension.height - dimension2.height) / 2;
                dialog.setLocation(new Point(n, n2));
            }
        }
    }

    public static void centerWindowOnScreen(Window window, int n, int n2) {
        if (window != null) {
            Dimension dimension = window.getToolkit().getScreenSize();
            Point point = window.getLocation();
            int n3 = point.x;
            int n4 = point.y;
            if (dimension.width > n) {
                n3 = (dimension.width - n) / 2;
            }
            if (dimension.height > n2) {
                n4 = (dimension.height - n2) / 2;
            }
            window.setLocation(new Point(n3, n4));
        }
    }

    public static void centerWindowOnScreen(Window window) {
        if (window != null) {
            Dimension dimension = window.getSize();
            Utilities.centerWindowOnScreen(window, dimension.width, dimension.height);
        }
    }

    public static JFrame createTestFrame(String string, int n, int n2) {
        JFrame jFrame = new JFrame(string);
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        int n3 = (dimension.width - n + 50) / 2;
        int n4 = (dimension.height - n2 + 50) / 2;
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(n + 50, n2 + 50);
        jFrame.setLocation(new Point(n3, n4));
        jFrame.setResizable(false);
        jFrame.setVisible(true);
        return jFrame;
    }

    public static JFrame createTestFrame(String string, Dialog dialog) {
        if (dialog == null) {
            return null;
        }
        Dimension dimension = dialog.getSize();
        return Utilities.createTestFrame(string, dimension.width, dimension.height);
    }
}

