/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SGLayout
implements LayoutManager,
Serializable {
    public static int LEFT = 0;
    public static int CENTER = 1;
    public static int RIGHT = 2;
    public static int FILL = 4;
    public static int TOP = 8;
    public static int BOTTOM = 16;
    protected int rows;
    protected int cols;
    protected int vgap;
    protected int hgap;
    protected int topBorder = 0;
    protected int leftBorder = 0;
    protected int bottomBorder = 0;
    protected int rightBorder = 0;
    protected int minW = 10;
    protected int minH = 10;
    protected double[] rowScale;
    protected double[] columnScale;
    protected int hAlignment = FILL;
    protected int vAlignment = FILL;
    protected int[][] hAlignments;
    protected int[][] vAlignments;
    protected int[] rowSizes;
    protected int[] columnSizes;

    public SGLayout() {
        this(2, 2, 0, 0, FILL, FILL);
    }

    public SGLayout(int n, int n2) {
        this(n, n2, 0, 0, FILL, FILL);
    }

    public SGLayout(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, FILL, FILL);
    }

    public SGLayout(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hAlignment = n3;
        this.vAlignment = n4;
        this.hgap = n5;
        this.vgap = n6;
        this.setDimensions(n, n2);
    }

    private void setScaleValues() {
        int n;
        this.rowScale = new double[this.rows];
        this.columnScale = new double[this.cols];
        for (n = 0; n < this.rows; ++n) {
            this.rowScale[n] = 1.0;
        }
        for (n = 0; n < this.cols; ++n) {
            this.columnScale[n] = 1.0;
        }
    }

    private void setAlignments() {
        this.hAlignments = new int[this.rows][this.cols];
        this.vAlignments = new int[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.hAlignments[i][j] = this.hAlignment;
                this.vAlignments[i][j] = this.vAlignment;
            }
        }
    }

    private void setDimensions(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.setScaleValues();
        this.setAlignments();
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.topBorder = n;
        this.leftBorder = n2;
        this.bottomBorder = n3;
        this.rightBorder = n4;
    }

    public void setRowScale(int n, double d) {
        if (n >= 0 && n < this.rows) {
            this.rowScale[n] = d;
        }
    }

    public void setColumnScale(int n, double d) {
        if (n >= 0 && n < this.cols) {
            this.columnScale[n] = d;
        }
    }

    public void setAlignment(int n, int n2, int n3, int n4) {
        if (n < this.rows && n2 < this.cols) {
            this.hAlignments[n][n2] = n3;
            this.vAlignments[n][n2] = n4;
        }
    }

    public void setRowAlignment(int n, int n2, int n3) {
        if (n < this.rows) {
            for (int i = 0; i < this.cols; ++i) {
                this.hAlignments[n][i] = n2;
                this.vAlignments[n][i] = n3;
            }
        }
    }

    public void setColumnAlignment(int n, int n2, int n3) {
        if (n < this.cols) {
            for (int i = 0; i < this.rows; ++i) {
                this.hAlignments[i][n] = n2;
                this.vAlignments[i][n] = n3;
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                int n6 = 0;
                int n7 = 0;
                for (int j = 0; j < n3; ++j) {
                    int n8 = i * n3 + j;
                    if (n8 >= n) continue;
                    Component component = container.getComponent(n8);
                    Dimension dimension = component.getPreferredSize();
                    n6 = dimension.width < this.minW ? (n6 += this.minW) : (n6 += dimension.width);
                    if (dimension.height <= n7) continue;
                    n7 = dimension.height;
                }
                if (n6 > n4) {
                    n4 = n6;
                }
                n5 += n7;
            }
            return new Dimension(n4 + this.leftBorder + this.rightBorder + (n3 - 1) * this.hgap, n5 + this.topBorder + this.bottomBorder + (n2 - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                int n6 = 0;
                int n7 = 0;
                for (int j = 0; j < n3; ++j) {
                    int n8 = i * n3 + j;
                    if (n8 >= n) continue;
                    Component component = container.getComponent(n8);
                    Dimension dimension = component.getMinimumSize();
                    int n9 = dimension.width;
                    if (n9 < this.minW) {
                        n9 = this.minW;
                    }
                    n6 += n9;
                    if (n7 <= dimension.height) continue;
                    n7 = dimension.height;
                }
                if (n4 > n6) {
                    n4 = n6;
                }
                if (n7 < this.minH) {
                    n7 = this.minH;
                }
                n5 += n7;
            }
            return new Dimension(n4 + this.leftBorder + this.rightBorder + (n3 - 1) * this.hgap, n5 + this.topBorder + this.bottomBorder + (n2 - 1) * this.vgap);
        }
    }

    public void layoutContainer(Container container) {
        int n = container.getSize().width - this.leftBorder - this.rightBorder;
        int n2 = container.getSize().height - this.topBorder - this.bottomBorder;
        int n3 = container.getComponentCount();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = this.topBorder;
        boolean bl3 = false;
        boolean bl4 = false;
        Dimension dimension = new Dimension(60, 30);
        this.allocateMaxSizes(container);
        for (int i = 0; i < this.rows; ++i) {
            int n5 = this.leftBorder;
            for (int j = 0; j < this.cols; ++j) {
                int n6 = i * this.cols + j;
                if (n6 > n3 - 1) continue;
                Component component = container.getComponent(n6);
                if (component.isVisible()) {
                    this.setComponentBounds(component, i, j, n5, n4);
                }
                n5 += this.columnSizes[j] + this.hgap;
            }
            n4 += this.rowSizes[i] + this.vgap;
        }
    }

    void setComponentBounds(Component component, int n, int n2, int n3, int n4) {
        int n5;
        Dimension dimension = component.getPreferredSize();
        int n6 = this.columnSizes[n2];
        int n7 = this.rowSizes[n];
        int n8 = n6 - dimension.width;
        if (n8 > 0) {
            n5 = this.hAlignments[n][n2];
            if (n5 == RIGHT) {
                n3 += n8;
            } else if (n5 == CENTER) {
                n3 += n8 / 2;
            }
            if (n5 != FILL) {
                n6 = dimension.width;
            }
        }
        if ((n5 = n7 - dimension.height) > 0) {
            int n9 = this.vAlignments[n][n2];
            if (n9 == BOTTOM) {
                n4 += n5;
            } else if (n9 == CENTER) {
                n4 += n5 / 2;
            }
            if (n9 != FILL) {
                n7 = dimension.height;
            }
        }
        component.setBounds(n3, n4, n6, n7);
    }

    protected void allocateMaxSizes(Container container) {
        int n;
        this.rowSizes = new int[this.rows];
        this.columnSizes = new int[this.cols];
        Dimension dimension = container.getSize();
        int n2 = dimension.width - this.leftBorder - this.rightBorder - (this.cols - 1) * this.hgap;
        int n3 = dimension.height - this.topBorder - this.bottomBorder - (this.rows - 1) * this.vgap;
        double d = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            d += this.rowScale[i];
        }
        double d2 = 0.0;
        for (n = 0; n < this.cols; ++n) {
            d2 += this.columnScale[n];
        }
        for (n = 0; n < this.rows; ++n) {
            this.rowSizes[n] = (int)(this.rowScale[n] * (double)n3 / d);
        }
        for (n = 0; n < this.cols; ++n) {
            this.columnSizes[n] = (int)(this.columnScale[n] * (double)n2 / d2);
        }
    }
}

