/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.test;

import com.slackandassociates.LabelledItemPanel;
import com.slackandassociates.dialogs.StandardDialog;
import com.slackandassociates.test.CustomerData;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CustomerDialog
extends StandardDialog {
    private static final String[] COUNTRY_LIST = new String[]{"Australia", "England", "Japan", "USA"};
    private JTextField myCustomerCodeField = new JTextField();
    private JTextField myNameField = new JTextField();
    private JTextArea myAddressField = new JTextArea(3, 20);
    private JTextField myCityField = new JTextField();
    private JTextField myStateField = new JTextField();
    private JTextField myPostcodeField = new JTextField();
    private JComboBox myCountryField = new JComboBox<String>(COUNTRY_LIST);
    private JTextField myContactField = new JTextField();
    private JTextField myPhoneField = new JTextField();
    private JTextField myFaxField = new JTextField();
    private JTextField myEmailField = new JTextField();
    private LabelledItemPanel myContentPane = new LabelledItemPanel();

    public CustomerDialog() {
        this.init();
    }

    private void init() {
        this.setTitle("Customer Dialog (StandardDialog)");
        this.myContentPane.setBorder(BorderFactory.createEtchedBorder());
        this.myContentPane.addItem("Customer Code", this.myCustomerCodeField);
        this.myContentPane.addItem("Name", this.myNameField);
        this.myContentPane.addItem("Address", new JScrollPane(this.myAddressField, 22, 31));
        this.myContentPane.addItem("City", this.myCityField);
        this.myContentPane.addItem("State", this.myStateField);
        this.myContentPane.addItem("Postcode", this.myPostcodeField);
        this.myContentPane.addItem("Country", this.myCountryField);
        this.myContentPane.addItem("Contact", this.myContactField);
        this.myContentPane.addItem("Phone", this.myPhoneField);
        this.myContentPane.addItem("Fax", this.myFaxField);
        this.myContentPane.addItem("Email", this.myEmailField);
        this.setContentPane(this.myContentPane);
    }

    public CustomerData getCustomerData() {
        CustomerData customerData = new CustomerData();
        customerData.myCustomerCode = this.myCustomerCodeField.getText();
        customerData.myName = this.myNameField.getText();
        customerData.myAddress = this.myAddressField.getText();
        customerData.myCity = this.myCityField.getText();
        customerData.myState = this.myStateField.getText();
        customerData.myPostcode = this.myPostcodeField.getText();
        customerData.myCountry = this.myCountryField.getSelectedItem().toString();
        customerData.myContact = this.myContactField.getText();
        customerData.myPhone = this.myPhoneField.getText();
        customerData.myFax = this.myFaxField.getText();
        customerData.myEmail = this.myEmailField.getText();
        return customerData;
    }

    public void setCustomerData(CustomerData customerData) {
        this.myCustomerCodeField.setText(customerData.myCustomerCode);
        this.myNameField.setText(customerData.myName);
        this.myAddressField.setText(customerData.myAddress);
        this.myCityField.setText(customerData.myCity);
        this.myStateField.setText(customerData.myState);
        this.myPostcodeField.setText(customerData.myPostcode);
        this.myCountryField.setSelectedItem(customerData.myCountry);
        this.myContactField.setText(customerData.myContact);
        this.myPhoneField.setText(customerData.myPhone);
        this.myFaxField.setText(customerData.myFax);
        this.myEmailField.setText(customerData.myEmail);
    }

    protected boolean isValidData() {
        if (this.myCustomerCodeField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter a Customer Code", "Blank Customer Code", 2);
            this.myCustomerCodeField.requestFocus();
            return false;
        }
        if (this.myNameField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter a Name", "Blank Name", 2);
            this.myNameField.requestFocus();
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        CustomerDialog customerDialog = new CustomerDialog();
        customerDialog.pack();
        customerDialog.show();
        if (!customerDialog.hasUserCancelled()) {
            CustomerData customerData = customerDialog.getCustomerData();
            customerData.printData();
        }
        System.exit(0);
    }
}

