/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.test;

import com.slackandassociates.LabelledItemPanel;
import com.slackandassociates.dialogs.StandardDialog;
import com.slackandassociates.test.CustomerData;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CustomerPanel
extends LabelledItemPanel {
    private static final String[] COUNTRY_LIST = new String[]{"Australia", "England", "Japan", "USA"};
    private JTextField myCustomerCodeField = new JTextField();
    private JTextField myNameField = new JTextField();
    private JTextArea myAddressField = new JTextArea(3, 20);
    private JTextField myCityField = new JTextField();
    private JTextField myStateField = new JTextField();
    private JTextField myPostcodeField = new JTextField();
    private JComboBox myCountryField = new JComboBox<String>(COUNTRY_LIST);
    private JTextField myContactField = new JTextField();
    private JTextField myPhoneField = new JTextField();
    private JTextField myFaxField = new JTextField();
    private JTextField myEmailField = new JTextField();

    public CustomerPanel() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addItem("Customer Code", this.myCustomerCodeField);
        this.addItem("Name", this.myNameField);
        this.addItem("Address", new JScrollPane(this.myAddressField, 22, 31));
        this.addItem("City", this.myCityField);
        this.addItem("State", this.myStateField);
        this.addItem("Postcode", this.myPostcodeField);
        this.addItem("Country", this.myCountryField);
        this.addItem("Contact", this.myContactField);
        this.addItem("Phone", this.myPhoneField);
        this.addItem("Fax", this.myFaxField);
        this.addItem("Email", this.myEmailField);
    }

    public CustomerData getCustomerData() {
        CustomerData customerData = new CustomerData();
        customerData.myCustomerCode = this.myCustomerCodeField.getText();
        customerData.myName = this.myNameField.getText();
        customerData.myAddress = this.myAddressField.getText();
        customerData.myCity = this.myCityField.getText();
        customerData.myState = this.myStateField.getText();
        customerData.myPostcode = this.myPostcodeField.getText();
        customerData.myCountry = this.myCountryField.getSelectedItem().toString();
        customerData.myContact = this.myContactField.getText();
        customerData.myPhone = this.myPhoneField.getText();
        customerData.myFax = this.myFaxField.getText();
        customerData.myEmail = this.myEmailField.getText();
        return customerData;
    }

    public void setCustomerData(CustomerData customerData) {
        this.myCustomerCodeField.setText(customerData.myCustomerCode);
        this.myNameField.setText(customerData.myName);
        this.myAddressField.setText(customerData.myAddress);
        this.myCityField.setText(customerData.myCity);
        this.myStateField.setText(customerData.myState);
        this.myPostcodeField.setText(customerData.myPostcode);
        this.myCountryField.setSelectedItem(customerData.myCountry);
        this.myContactField.setText(customerData.myContact);
        this.myPhoneField.setText(customerData.myPhone);
        this.myFaxField.setText(customerData.myFax);
        this.myEmailField.setText(customerData.myEmail);
    }

    public static void main(String[] stringArray) {
        CustomerPanel customerPanel = new CustomerPanel();
        StandardDialog standardDialog = new StandardDialog((Frame)null, "Customer Details (LabelledItemPanel)");
        standardDialog.setContentPane(customerPanel);
        standardDialog.pack();
        standardDialog.show();
        if (!standardDialog.hasUserCancelled()) {
            CustomerData customerData = customerPanel.getCustomerData();
            customerData.printData();
        }
        System.exit(0);
    }
}

