import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import au.com.virturo.guiutils.*;
import com.slackandassociates.Utilities;

/**
 * Class defines the dialog used for the getting the hand totals from the player
 * for the game of Cribbage.  Uses a spinner component created by Kevin Mayer 
 * (kmayer@layer9.com) and a listener class created by Bernard Johnston. <br><br>
 * <b>Changes:</b>
 * <ul>
 * <li> 2001/09/22 - Initial release.
 * <li> 2002/01/05 - Modified to use Utilities class from slack.jar.
 * <li> 2003-08-10 - Fixed label font in dialog to display properly under GCD
 *                   Java 1.4.1.
 * <li> 2005-01-21 - Added main test method to class.
 * <li> 2005-04-28 - Fixed an issue that 'findbugs' found within setupDialog method.
 * </ul>
 * @author Michael G. Slack
 * @author slack@attglobal.net
 * @created 2001-09-22
 * @version 2005-04-28 Version 1.04
*/
public class CribbageScoreDlg extends JDialog
{
    // statics (maybe move to resource bundle later???)
    private static final String S_POINTS = "Points";
    private static final String S_CRIBPOINTS = "Crib Points";
    private static final String S_HOWMANY = "How many points do you have?";
    private static final String S_INVALID = "Invalid number entered.";
    private static final String S_TOOMANY = "Too many points for that hand!";
    private static final String S_MSGTIT = "Error";

    // window size constants
    private static final int D_DLG_WIDTH = 200;
    private static final int D_DLG_HEIGHT = 130;

    // components used by dialog
    private JPanel dPnl1 = new JPanel();
    private JPanel dPnl2 = new JPanel();
    private JPanel dPnl3 = new JPanel();
    private JLabel dL1 = new JLabel(S_HOWMANY, SwingConstants.CENTER);
    private JTextField textFld = new JTextField("0", 3);
    private Spinner spinEdit = new Spinner(textFld);
    private JButton dB1 = new JButton("OK");

    // references
    private ImageIcon mbStopImg = null;
    private int maxPoints = 0;
    public int retPoints = 0;

    // ------------------------ Constructor -------------------------

    /** Constructor to create the point dialog used by the Cribbage game.
     * @param parent JFrame that dialog is a child of.
     * @param crib A boolean that indicates which title to use.
     * @param maxPoints An int value used during close processing to check
     * the score entered to make sure it is not greater than score in hand.
    */
    public CribbageScoreDlg(JFrame parent, boolean crib, int maxPoints,
                            ImageIcon mbStopImg)
    {
        super(parent, S_POINTS, true);

        // set up things now
        if (crib) setTitle(S_CRIBPOINTS);
        this.maxPoints = maxPoints;
        this.mbStopImg = mbStopImg;

        setupDialog();
        Utilities.centerDialog(parent, this);
    }

    // ----------------------- Private Methods --------------------------

    private void setupDialog()
    {
        Container cp = getContentPane();

        setSize(D_DLG_WIDTH, D_DLG_HEIGHT);
        cp.setLayout(new BorderLayout());
        dPnl1.setLayout(new GridLayout(2, 1));
        dL1.setFont(new Font("Helvetica", Font.PLAIN, 12));
        dPnl1.add(dL1);
        spinEdit.addSpinListener(new IntSpinListener(0, 100));
        dPnl2.add(spinEdit);
        dPnl1.add(dPnl2);
        cp.add(dPnl1, BorderLayout.CENTER);
        dB1.addActionListener(new ActionListener() {
                                      public void actionPerformed(ActionEvent evt) {
                                          boolean valid = true;
                                          int choice = 0;
                                          String errS = "";
                                          try {
                                              String ss = textFld.getText().trim();
                                              // if ((ss == null) || ("".equals(ss)))
                                              if ("".equals(ss))
                                                  choice = 0;
                                              else
                                                  choice = Integer.parseInt(ss);
                                          }
                                          catch(NumberFormatException n) {
                                              valid = false;
                                              errS = S_INVALID;
                                          }
                                          if (valid) { // check value entered then...
                                              if (choice < 0) choice = 0;
                                              if (choice > maxPoints) {
                                                  valid = false;
                                                  errS = S_TOOMANY;
                                              }
                                              else {
                                                  retPoints = choice;
                                              }
                                          }
                                          if (valid) {
                                              dispose(); // close the dialog
                                          }
                                          else {
                                              JOptionPane.showMessageDialog(null,
                                                                errS,
                                                                S_MSGTIT,
                                                                JOptionPane.ERROR_MESSAGE,
                                                                mbStopImg);
                                          }
                                      }
                                  });
        dPnl3.add(dB1);
        cp.add(dPnl3, BorderLayout.SOUTH);
    }

    // ------------------------- Public Methods --------------------------

    /** Method used to return the number of points entered into the dialog. */
    public int getPoints()
    {
        return retPoints;
    }

    /** Method to invoke display/run of score dialog.  Test method.
     * @param args String array of parameters, not used.
    */
    public static void main(String[] args)
    {
        JFrame frame = Utilities.createTestFrame("Cribbage Score Test",
                                                 D_DLG_WIDTH, D_DLG_HEIGHT);
        CribbageException ce = new CribbageException(); // need for class ref
        Image temp = Utilities.loadImage(ce, frame.getToolkit(), "images/", "hand.gif");
        ImageIcon mbStopImg = new ImageIcon(temp);
        int max = ((int)(Math.random() * 20)) + 5;
        boolean crib = false;

        // do crib score or not...
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("crib"))
                crib = true;
            else if (args[0].equalsIgnoreCase("random"))
                crib = ((int) (Math.random() * 10) > 6);
        }

        CribbageScoreDlg dlg = new CribbageScoreDlg(frame, crib, max, mbStopImg);
        dlg.show();
        System.out.println("Crib score: " + crib + ", max points = " + max);
        System.out.println(" Entered points = " + dlg.getPoints());
    }
}
