/*
(c) 1995 Carsten Hrle
Letzte nderung: 26.10.95

Rexx-Skript fr den Emis/PM MausTausch fr verschiedene
Terminal-Programme. Das Verzeichnis der Mitteilungsbank
mu bergeben werden. Dort wird auch auch die Datei
'emismt.cfg' gelesen.

Ausserdem kann man mit den beiden Variablen 'archiv' und 'za'
festlegen, ob man zur Sicherheit ein zustzliches Archiv der
outfiles anlegen will. Sie werden dann im Verzeichnei eigener Wahl
mit dem Datum abgelegt.

*/

archiv = "" /* Pfad fr zustzliches Archiv (z.B d:\notarchiv)*/

arg msgBaseDir

/* Prfe, ob das Verzeichnis existiert */
curDir = directory()
if msgBaseDir \= "" Then do
        if substr(msgBaseDir, length(msgBaseDir),1) = '\' Then
                msgBaseDir = substr(msgBaseDir, 1, length(msgBaseDir)-1)
        msgBaseDir = directory(msgBaseDir)
End
If msgBaseDir = "" Then
        Error("Verzeichnis der Mitteilungsbank nicht gefunden", 10002);
say "Mitteilungsbank im Verzeichnis:" msgBaseDir

/* Packen des INFILEs und Lschen des OUTFILE.ZIP */
'del infile.zip'
'zip infile infile.txt'
if rc \= 0 Then Error("Infile kann nicht gepackt werden", 10003)
'del outfile.zip'

/* Lesen des MausTausch-Programms */
if stream('emismt.cfg', 'c', 'open read') \= 'READY:' then
        Error("Fehler beim Lesen der Datei 'emismt.cfg'", 10001)
progid=linein("emismt.cfg")
if stream('emismt.cfg', 'c', 'close') \= 'READY:' then
        Error("Fehler beim Lesen der Datei 'emismt.cfg'", 10001)

/* Starte das spezielle Skript */
Call directory(curDir)
'call' progid msgBaseDir
if rc  \= 0 Then Error("Fehler beim MausTausch-Skript", rc)
 
/* Auspacken des OUTFILEs */
Call directory(msgBaseDir)

/* Aufruf fr Zusatzarchiv */
if archiv \= "" then call ZUSATZARCHIV
 
'del outfile.txt'
'unzip outfile'
if rc \= 0 Then
        Error("Outfile kann nicht ausgepackt werden", 10004)
Say ("Emis-MausTausch erfolgreich")
exit 0

/* Zustzliche Archivierung */
ZUSATZARCHIV:
dname = DATE(S)
zaehl = 0
flagg = 0
DO WHILE (FLAGG = 0)
  FILENAME = archiv"\"DNAME"_"ZAEHL".ZIP"
  ERGEBNIS = STREAM(FILENAME, "C", "QUERY EXISTS")
  if ERGEBNIS = " " THEN
  do
    'copy' outfile.zip FILENAME
    FLAGG = 1
  end
  else
  do
    ZAEHL = ZAEHL + 1
  end
END
return

/* Fehlerbehandlung */
Error:
Say "FEHLER ("arg(2)"): " arg(1)
/* pull a */
Exit arg(2)
