/* TAUSCH2.CMD -- w'94-95
------------------------------------------------------------------------------
Dieses Script ist Public domain.

Syntax: TAUSCH2 {Nummer Benutzername Pawort} | RELOGIN

Fehlercodes: 0 - Alles OK
             1 - fehlerhafte Syntax
             2 - Modem nicht ansprechbar
             3 - Fehler beim Senden des Infiles
             4 - Fehler beim Empfangen des Outfiles
             5 - Maximale Anzahl von Anwahlversuchen erreicht
             6 - Timeout whrend des Tauschs
             10 - Sonstiger Fehler
------------------------------------------------------------------------------
*/


cr           = d2c(13)
lf           = d2c(10)
crlf         = cr||lf
TRUE         = 1 == 1
FALSE        = \ TRUE

logfile      = 'tausch2.log'

portname     = 'COM2'
baudrate     = 38400
databits     = 8
parity       = 'N'
stopbits     = 1

resetstring  = 'ATZ'cr
resetstring2 = 'atm0'cr
dialtimeout  = 60
dialpause    = 120
dialtimes    = 10
dialstring   = 'ATDP'

signalup     = '**'||d2c(24)||'B01'
signaldown   = '**'||d2c(24)||'B00'

/* CEXYZ2 */

ftpsend      = '"cexyz2 /p"porthandle "/l"baudrate "/b14400 /sz infile.zip"'
ftpreceive   = '"cexyz2 /p"porthandle "/l"baudrate "/b14400 /rz"'


/* P (alte Version) */
/*
ftpsend      = '"c:\comm\p\p" portname baudrate "-m sz infile.zip"'
ftpreceive   = '"c:\comm\p\p" portname baudrate "-m rz"'
*/

/* P 2.05 */
/*
ftpsend      = '"c:\comm\p\p -handle" porthandle "-speed" baudrate "-send infile.zip"'
ftpreceive   = '"c:\comm\p\p -handle" porthandle "-speed" baudrate "-receive"'
*/

/* Vorbereitung */

call on error

globals      = 'failure porthandle logfile TRUE FALSE'
porthandle   = ''


relogin = pos('RELOG', translate(arg(1))) > 0

if \ relogin then do
  call xparse arg(1) with mausnummer maususer mauspassword

  if mauspassword == '' then do
    say crlf||'Syntax: TAUSCH2 {Nummer Benutzername Pawort} | RELOGIN'
    say crlf||'Beispiel: TAUSCH2 477275 "Werner Hunger" "verrateichnicht"'
    exit 1
  end
end


call rxfuncadd 'rxasyncloadfuncs', 'rxasync', 'rxasyncloadfuncs'
call rxasyncloadfuncs

call rxasyncopen portname, 'porthandle'
call rxasyncsetlnctrl porthandle, baudrate, databits, parity, stopbits
call rxasyncsetdcbinfo porthandle, 50, 50, '00001001', '10100000',,
                                           '00000010', 0, 0, 11, 13


if stream(logfile, 'c', 'query exists') > '' then 'del' logfile


if relogin then do

  /* Verbindung ist noch offen: Tausch mittels 't' einleiten */

  call output 't'
  call input 3, 'Protokoll:'
  if failure then call error 6
  call output 'z'
end
else do

  /* Modem-Reset */

  call output cr
  call input 1, '', FALSE
  call output resetstring
  call input 3, 'OK', FALSE
  if failure then call error 2
  call output resetstring2
  call input 3, 'OK', FALSE
  if failure then call error 2


  /* schwierig: whlen ;-) */

  versuch = 1

  do until verbindung

    say left(versuch||'. Versuch:', 40)
    call output dialstring||mausnummer||cr

    call time 'R'
    do until verbindung | failure | (time('E') > dialtimeout)
      call charout CON, 'Whle '||mausnummer||', Timeout in '
      call charout CON, trunc(dialtimeout - time('E')) 'Sekunden ... '||cr

      s = input(1, cr, FALSE)
      verbindung = pos('CONNECT', s) > 0
      failure = pos('NO', s) + pos('OUT OF', s) +,
                pos('DELAY', s) + pos('BUSY', s) > 0
    end

    if \ verbindung then do
      call output cr

      say crlf||'Status:' s

      if versuch == dialtimes then call error 5
      versuch = versuch + 1

      call time 'R'
      do until time('E') > dialpause
        call charout CON, 'Warte' trunc(dialpause - time('E'))
        call charout CON, ' Sekunden ... '||cr
        call rxasyncsleep 500
      end
    end
  end

  /* Verbindung steht: Jetzt geht's los ... */

  call input 15, 'Benutzer?'
  if failure then call error 6
  call output 'MausTausch'||maususer||cr||mauspassword||cr||'z'
end


/* Ab hier ist das Verhalten fr Schnell- und Normaltausch identisch */

call input 45, signalup
if failure then call error 6
interpret ftpsend
if rc \= 0 then call error 3

call input 600, signaldown
if failure then call error 6
interpret ftpreceive
if rc \= 0 then call error 4

/* Im Falle eines Schnelltauschs die kompletten Infos der Maus empfangen: */

if \ relogin then call input 30, 'NO CARRIER'


call aufraeumen

exit 0



/* interne Funktionen */

output: procedure expose (globals)
parse arg s
  failure = rxasyncwrite(porthandle, 0, s, 'dummy') \= 0
return


input: procedure expose (globals)
parse arg timeout, trigger, show
  if show = '' then show = TRUE
  failure = TRUE
  s = ''

  call time 'R'

  do until \ failure | (time('E') > timeout)
    call rxasyncread porthandle, 0, 500, 's'
    if show then call charout CON, s
    call charout logfile, s

    failure = pos(trigger, s) = 0
  end
return s


/* xparse: erkennt in Anfhrungszeichen gesetzte Parameter korrekt */

xparse:
parse arg line 'WITH' pvars
  do while pvars > ''
    parse value line with par rest
    if pos('"', par) > 0 then parse value line with '"' par '"' rest
    line = rest

    parse value pvars with varname pvars
    interpret varname '= par'
  end
return


/* Aufrumen */

aufraeumen:
  call rxasyncclose porthandle        /* Verbindung trennen */
  call rxasyncdropfuncs
  call stream logfile, 'c', 'close'
return


/* Fr den Fall aller Flle */

error:
parse arg code
  call aufraeumen

  select
    when code == 1 then say 'Fehlerhafte Syntax!'
    when code == 2 then say 'Modem nicht ansprechbar!',
                            'Oder etwa ausgeschaltet?'
    when code == 3 then say 'Fehler beim Senden des Infiles!'
    when code == 4 then say 'Fehler beim Empfangen des Outfiles!'
    when code == 5 then say 'Maximale Anzahl von Anwahlversuchen erreicht.'
    when code == 6 then say 'Timeout whrend des Tauschs!'
    otherwise
      say 'Unbekannter Fehler!'
      code = 10
  end

  exit code
