/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.card;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Card {
    public static int DEFAULT_HEIGHT = 129;
    public static int DEFAULT_WIDTH = 86;
    private boolean faceDown;
    private Point location;
    private Dimension size = new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT);

    public abstract String toString();

    public abstract void paint(Graphics var1, boolean var2);

    public boolean isFaceDown() {
        return this.faceDown;
    }

    public void turnFaceUp() {
        this.faceDown = false;
    }

    public void turnFaceDown() {
        this.faceDown = true;
    }

    public void flip() {
        if (this.isFaceDown()) {
            this.turnFaceUp();
        } else {
            this.turnFaceDown();
        }
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point p) {
        this.location = new Point(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.location = new Point(x, y);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(int width, int height) {
        this.size = new Dimension(width, height);
    }

    public void setSize(Dimension dim) {
        this.size = new Dimension(dim.width, dim.height);
    }

    public boolean contains(Point p) {
        Rectangle rect = new Rectangle(this.location.x, this.location.y, this.size.width, this.size.height);
        return rect.contains(p);
    }
}

