/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.card;

import com.fbergeron.card.Card;
import com.fbergeron.card.Suit;
import com.fbergeron.card.Value;
import com.fbergeron.util.Util;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.util.Hashtable;

public class ClassicCard
extends Card {
    public static final String STRING_HIDDEN = "X";
    public static final int BORDER_ARC = 20;
    public static final Color CARD_COLOR = Color.blue;
    private static Hashtable images = new Hashtable();
    private static MediaTracker tracker = new MediaTracker(new Button());
    private Suit suit;
    private Value value;
    private String imgName;
    private boolean legal;
    private ImageObserver imgObserver;
    private Image img;

    public ClassicCard(ClassicCard card) {
        this.img = card.img;
        this.imgName = card.imgName;
        this.imgObserver = card.imgObserver;
        this.suit = card.suit;
        this.value = card.value;
        this.setLocation(card.getLocation());
        this.setSize(card.getSize());
        if (card.isFaceDown()) {
            this.turnFaceDown();
        } else {
            this.turnFaceUp();
        }
    }

    public ClassicCard(Value value, Suit suit) {
        this.suit = suit;
        this.value = value;
        StringBuffer tmpImgName = new StringBuffer(suit.toString());
        tmpImgName.append("/").append(value.toString());
        this.imgName = tmpImgName.toString();
        this.legal = false;
        this.turnFaceDown();
    }

    public boolean isLegal() {
        return this.legal;
    }

    public void setLegal(boolean legal) {
        this.legal = legal;
    }

    public void setImageObserver(ImageObserver imgObserver) {
        this.imgObserver = imgObserver;
    }

    public Color getColor() {
        return this.suit == Suit.SPADE || this.suit == Suit.CLUB ? Color.black : Color.red;
    }

    public Value getValue() {
        return this.value;
    }

    public Suit getSuit() {
        return this.suit;
    }

    public boolean equals(Object obj) {
        return this.isFaceDown() == ((ClassicCard)obj).isFaceDown() && this.suit == ((ClassicCard)obj).suit && this.value == ((ClassicCard)obj).value;
    }

    @Override
    public String toString() {
        StringBuffer strBufTemp = new StringBuffer();
        if (this.isFaceDown()) {
            strBufTemp.append(STRING_HIDDEN);
        }
        strBufTemp.append(this.value.toString());
        strBufTemp.append(this.suit.toString());
        if (this.isFaceDown()) {
            strBufTemp.append(STRING_HIDDEN);
        }
        return strBufTemp.toString();
    }

    @Override
    public void paint(Graphics g, boolean hint) {
        Point location = this.getLocation();
        RoundRectangle2D.Double border = new RoundRectangle2D.Double(location.x, location.y, this.getSize().width - 1, this.getSize().height - 1, 20.0, 20.0);
        g.setClip(border);
        if (this.isFaceDown()) {
            g.setColor(CARD_COLOR);
            g.fillRect(location.x, location.y, this.getSize().width - 1, this.getSize().height - 1);
        } else {
            g.setColor(Color.white);
            g.fillRect(location.x, location.y, this.getSize().width - 1, this.getSize().height - 1);
            Image img = (Image)images.get(this.imgName);
            if (img != null && this.imgObserver != null) {
                g.drawImage(img, location.x + 3, location.y + 3, this.imgObserver);
            }
            if (hint && this.legal && (img = (Image)images.get("Legal")) != null && this.imgObserver != null) {
                g.drawImage(img, location.x + 3, location.y + 3, this.imgObserver);
            }
        }
        g.setClip(null);
        g.setColor(Color.black);
        g.drawRoundRect(location.x, location.y, this.getSize().width - 1, this.getSize().height - 1, 20, 20);
    }

    static {
        for (int i = 0; i < Suit.suits.length; ++i) {
            for (int j = 0; j < Value.values.length; ++j) {
                StringBuffer imgFilename = new StringBuffer(Suit.suits[i].toString());
                imgFilename.append("/").append(Value.values[j].toString());
                String imgName = imgFilename.toString();
                imgFilename.append(".png");
                Image img = Util.getImageResourceFile(imgFilename.toString(), ClassicCard.class);
                tracker.addImage(img, 0);
                images.put(imgName, img);
            }
        }
        String imgName = "Legal";
        Image img = Util.getImageResourceFile(imgName + ".png", ClassicCard.class);
        tracker.addImage(img, 0);
        images.put(imgName, img);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

