/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.card;

import com.fbergeron.card.Card;
import com.fbergeron.card.ClassicCard;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class Stack {
    public static final int SPREAD_NONE = 0;
    public static final int SPREAD_NORTH = 1;
    public static final int SPREAD_EAST = 2;
    public static final int SPREAD_SOUTH = 3;
    public static final int SPREAD_WEST = 4;
    private Vector cards = new Vector();
    private Point location;
    private Point nextCardLocation;
    private int spreadDirection;
    private int spreadingDelta;

    public Stack() {
        this.setLocation(0, 0);
    }

    public boolean isEmpty() {
        return this.cards.isEmpty();
    }

    public Vector getCards() {
        return this.cards;
    }

    public int firstFaceUp() {
        for (int i = 0; i < this.cards.size(); ++i) {
            ClassicCard c = (ClassicCard)this.cards.get(i);
            if (c.isFaceDown()) continue;
            return i;
        }
        return -1;
    }

    public Card top() {
        if (this.cards.size() == 0) {
            return null;
        }
        return (Card)this.cards.elementAt(this.cards.size() - 1);
    }

    public Card elementAt(int index) {
        return (Card)this.cards.elementAt(index);
    }

    public void push(Card c) {
        this.cards.addElement(c);
        c.setLocation(this.nextCardLocation);
        switch (this.spreadDirection) {
            case 1: {
                this.nextCardLocation.y -= this.spreadingDelta;
                break;
            }
            case 2: {
                this.nextCardLocation.x += this.spreadingDelta;
                break;
            }
            case 3: {
                this.nextCardLocation.y += this.spreadingDelta;
                break;
            }
            case 4: {
                this.nextCardLocation.x -= this.spreadingDelta;
            }
        }
    }

    public void push(Stack sc) {
        while (!sc.isEmpty()) {
            this.push(sc.pop());
        }
    }

    public Card pop() {
        Card c = this.top();
        this.cards.removeElement(c);
        switch (this.spreadDirection) {
            case 1: {
                this.nextCardLocation.y += this.spreadingDelta;
                break;
            }
            case 2: {
                this.nextCardLocation.x -= this.spreadingDelta;
                break;
            }
            case 3: {
                this.nextCardLocation.y -= this.spreadingDelta;
                break;
            }
            case 4: {
                this.nextCardLocation.x += this.spreadingDelta;
            }
        }
        return c;
    }

    public Stack pop(int n) {
        Stack s = new Stack();
        for (int i = n; i > 0 && !this.isEmpty(); --i) {
            s.push(this.pop());
        }
        s.setSpreadingDelta(this.spreadingDelta);
        s.setSpreadingDirection(this.spreadDirection);
        return s;
    }

    public Stack pop(Card c) {
        Stack s = new Stack();
        while (!this.top().equals(c) && !this.isEmpty()) {
            s.push(this.pop());
        }
        if (!this.isEmpty()) {
            s.push(this.pop());
        }
        s.setSpreadingDelta(this.spreadingDelta);
        s.setSpreadingDirection(this.spreadDirection);
        return s;
    }

    public int cardCount() {
        return this.cards.size();
    }

    public boolean contains(Card c) {
        return this.cards.contains(c);
    }

    public boolean contains(Point p) {
        Rectangle rect = null;
        switch (this.spreadDirection) {
            case 0: {
                rect = new Rectangle(this.location.x, this.location.y, Card.DEFAULT_WIDTH, Card.DEFAULT_HEIGHT);
                break;
            }
            case 1: {
                int height = Card.DEFAULT_HEIGHT + (this.cards.size() - 1) * this.spreadingDelta;
                rect = new Rectangle(this.location.x - height, this.location.y, height, Card.DEFAULT_WIDTH);
                break;
            }
            case 2: {
                rect = new Rectangle(this.location.x, this.location.y, Card.DEFAULT_WIDTH + (this.cards.size() - 1) * this.spreadingDelta, Card.DEFAULT_HEIGHT);
                break;
            }
            case 3: {
                rect = new Rectangle(this.location.x, this.location.y, Card.DEFAULT_WIDTH, Card.DEFAULT_HEIGHT + (this.cards.size() - 1) * this.spreadingDelta);
                break;
            }
            case 4: {
                int width = Card.DEFAULT_WIDTH + (this.cards.size() - 1) * this.spreadingDelta;
                rect = new Rectangle(this.location.x - width, this.location.y, width, Card.DEFAULT_HEIGHT);
            }
        }
        return rect.contains(p);
    }

    public boolean isValid(Card c) {
        return true;
    }

    public boolean isValid(Stack c) {
        return true;
    }

    public int getSpreadingDirection() {
        return this.spreadDirection;
    }

    public void setSpreadingDirection(int sd) {
        this.spreadDirection = sd;
    }

    public int getSpreadingDelta() {
        return this.spreadingDelta;
    }

    public void setSpreadingDelta(int delta) {
        this.spreadingDelta = delta;
    }

    public void paint(Graphics g, boolean hint) {
        if (this.isEmpty()) {
            Point loc = this.getLocation();
            g.setColor(Color.darkGray);
            g.fillRect(loc.x, loc.y, Card.DEFAULT_WIDTH, Card.DEFAULT_HEIGHT);
            g.setColor(Color.black);
            g.drawRect(loc.x, loc.y, Card.DEFAULT_WIDTH, Card.DEFAULT_HEIGHT);
        } else {
            Enumeration e = this.cards.elements();
            while (e.hasMoreElements()) {
                Card c = (Card)e.nextElement();
                c.paint(g, hint);
            }
        }
    }

    public Card getClickedCard(Point p) {
        boolean cardFound = false;
        Card c = null;
        for (int i = this.cards.size() - 1; !cardFound && i >= 0; --i) {
            c = (Card)this.cards.elementAt(i);
            cardFound = c.contains(p);
        }
        return c;
    }

    public void reverse() {
        Vector<Card> v = new Vector<Card>();
        while (!this.isEmpty()) {
            v.addElement(this.pop());
        }
        this.cards = v;
    }

    public void setLocation(int x, int y) {
        this.location = new Point(x, y);
        if (this.cards != null) {
            Enumeration e = this.cards.elements();
            while (e.hasMoreElements()) {
                Card c = (Card)e.nextElement();
                c.setLocation(x, y);
                switch (this.spreadDirection) {
                    case 1: {
                        y -= this.spreadingDelta;
                        break;
                    }
                    case 2: {
                        x += this.spreadingDelta;
                        break;
                    }
                    case 3: {
                        y += this.spreadingDelta;
                        break;
                    }
                    case 4: {
                        x -= this.spreadingDelta;
                    }
                }
            }
        }
        this.setNextCardLocation(x, y);
    }

    public Point getLocation() {
        return this.location;
    }

    public String toString() {
        return this.cards.toString();
    }

    private void setNextCardLocation(int x, int y) {
        this.nextCardLocation = new Point(x, y);
    }

    private void setNextCardLocation(Point nextCardLocation) {
        this.nextCardLocation = nextCardLocation;
    }

    private Point getNextCardLocation() {
        return this.nextCardLocation;
    }
}

