/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.solitaire;

import com.fbergeron.card.ClassicCard;
import com.fbergeron.card.ClassicDeck;
import com.fbergeron.card.Stack;
import com.fbergeron.card.Value;
import com.fbergeron.solitaire.GameInfo;
import com.fbergeron.solitaire.Move;
import com.fbergeron.solitaire.SequentialStack;
import com.fbergeron.solitaire.SolitaireStack;
import java.util.ArrayList;

public class GameState {
    protected GameInfo gameInfo;
    protected ClassicDeck deck;
    protected Stack revealedCards;
    protected SolitaireStack[] solStack;
    protected SequentialStack[] seqStack;
    protected boolean verbose;
    protected Stack src;
    protected Stack dst;
    protected Stack curr;

    public boolean isGameWon() {
        boolean gameWon;
        boolean bl = gameWon = this.deck.isEmpty() && this.revealedCards.isEmpty();
        if (gameWon) {
            for (int i = 0; i < 7 && gameWon; ++i) {
                gameWon = gameWon && this.solStack[i].isEmpty();
            }
        }
        return gameWon;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null || !(obj instanceof GameState)) {
            return false;
        }
        GameState gs = (GameState)obj;
        if (!this.gameInfo.equals(gs.gameInfo)) {
            return false;
        }
        if (this.deck.getCards().size() != gs.deck.getCards().size() || this.revealedCards.getCards().size() != gs.revealedCards.getCards().size()) {
            return false;
        }
        for (i = 0; i < 7; ++i) {
            if (this.solStack[i].cardCount() == gs.solStack[i].cardCount()) continue;
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (this.seqStack[i].cardCount() == gs.seqStack[i].cardCount()) continue;
            return false;
        }
        return true;
    }

    public ArrayList<GameState> legalMoves(boolean verbose) {
        ClassicCard c;
        ClassicCard cc;
        int k;
        int i;
        ArrayList<GameState> legalGs = new ArrayList<GameState>();
        int j = -1;
        this.verbose = verbose;
        for (i = 0; i < 7; ++i) {
            for (k = 0; k < this.solStack[i].cardCount(); ++k) {
                cc = (ClassicCard)this.solStack[i].elementAt(k);
                cc.setLegal(false);
            }
        }
        for (i = 0; i < 4; ++i) {
            for (k = 0; k < this.seqStack[i].cardCount(); ++k) {
                cc = (ClassicCard)this.seqStack[i].elementAt(k);
                cc.setLegal(false);
            }
        }
        for (i = 0; i < this.revealedCards.cardCount(); ++i) {
            ClassicCard cc2 = (ClassicCard)this.revealedCards.elementAt(i);
            cc2.setLegal(false);
        }
        for (i = 0; i < this.deck.cardCount(); ++i) {
            ClassicCard cc3 = (ClassicCard)this.deck.elementAt(i);
            cc3.setLegal(false);
        }
        for (i = 0; i < 7; ++i) {
            j = this.solStack[i].firstFaceUp();
            if (j == -1) continue;
            c = (ClassicCard)this.solStack[i].elementAt(j);
            this.legalSolToSol(legalGs, c, i);
            this.legalSolToSeq(legalGs, c, i);
            if (j + 1 == this.solStack[i].cardCount()) continue;
            j = this.solStack[i].cardCount() - 1;
            c = (ClassicCard)this.solStack[i].elementAt(j);
            this.legalSolToSeq(legalGs, c, i);
        }
        c = (ClassicCard)this.revealedCards.top();
        this.legalRevToSeq(legalGs, c);
        this.legalRevToSol(legalGs, c);
        if (legalGs.size() == 0 && verbose) {
            System.out.println("No moves!");
        }
        if (verbose) {
            System.out.println("Sol Legal moves " + legalGs.size());
        }
        return legalGs;
    }

    private void legalSolToSol(ArrayList<GameState> legalGs, ClassicCard c, int i) {
        if (c.getValue() == Value.V_ACE) {
            return;
        }
        SolitaireStack src = this.solStack[i];
        Stack currStack = src.pop(c);
        currStack.reverse();
        Stack curr = currStack;
        if (curr != null) {
            curr.reverse();
        }
        for (int j2 = 0; j2 < 7; ++j2) {
            SolitaireStack dst;
            if (j2 == i || (dst = this.solStack[j2]) == null || !((Stack)dst).isValid(curr) || !(src.isEmpty() | (!src.isEmpty() && src.top().isFaceDown())) || src.isEmpty() && dst.isEmpty()) continue;
            ClassicCard cOut = (ClassicCard)curr.elementAt(curr.cardCount() - 1);
            if (this.verbose) {
                System.out.println("Legal Move " + cOut.getValue() + cOut.getSuit() + " To Sol Stack " + (j2 + 1));
            }
            cOut.setLegal(true);
        }
        while (!curr.isEmpty()) {
            src.push(curr.pop());
        }
    }

    private void legalSolToSeq(ArrayList<GameState> legalGs, ClassicCard c, int i) {
        SolitaireStack src = this.solStack[i];
        Stack currStack = src.pop(c);
        currStack.reverse();
        Stack curr = currStack;
        if (curr != null) {
            curr.reverse();
        }
        if (curr.cardCount() > 2) {
            while (!curr.isEmpty()) {
                src.push(curr.pop());
            }
            return;
        }
        for (int j2 = 0; j2 < 4; ++j2) {
            SequentialStack dst = this.seqStack[j2];
            if (dst == null || !((Stack)dst).isValid(curr)) continue;
            ClassicCard cOut = (ClassicCard)curr.elementAt(curr.cardCount() - 1);
            if (this.verbose) {
                System.out.println("Legal Move " + cOut.getValue() + cOut.getSuit() + " To Seq Stack " + (j2 + 1));
            }
            cOut.setLegal(true);
            while (!curr.isEmpty()) {
                src.push(curr.pop());
            }
            return;
        }
        while (!curr.isEmpty()) {
            src.push(curr.pop());
        }
    }

    private void legalRevToSol(ArrayList<GameState> legalGs, ClassicCard c) {
        if (this.revealedCards.isEmpty()) {
            return;
        }
        Stack src = this.revealedCards;
        Stack currStack = src.pop(c);
        currStack.reverse();
        Stack curr = currStack;
        if (curr != null) {
            curr.reverse();
        }
        for (int j2 = 0; j2 < 7; ++j2) {
            SolitaireStack dst = this.solStack[j2];
            if (dst == null || !((Stack)dst).isValid(curr)) continue;
            ClassicCard cOut = (ClassicCard)curr.elementAt(0);
            if (this.verbose) {
                System.out.println("Legal Move " + cOut.getValue() + cOut.getSuit() + " To Sol Stack " + (j2 + 1));
            }
            cOut.setLegal(true);
        }
        while (!curr.isEmpty()) {
            src.push(curr.pop());
        }
    }

    private void legalRevToSeq(ArrayList<GameState> legalGs, ClassicCard c) {
        if (this.revealedCards.isEmpty()) {
            return;
        }
        Stack src = this.revealedCards;
        Stack currStack = src.pop(c);
        currStack.reverse();
        Stack curr = currStack;
        if (curr != null) {
            curr.reverse();
        }
        if (curr.cardCount() > 2) {
            while (!curr.isEmpty()) {
                src.push(curr.pop());
            }
            return;
        }
        for (int j2 = 0; j2 < 4; ++j2) {
            SequentialStack dst = this.seqStack[j2];
            if (dst == null || !((Stack)dst).isValid(curr)) continue;
            ClassicCard cOut = (ClassicCard)curr.elementAt(0);
            if (this.verbose) {
                System.out.println("Legal Move " + cOut.getValue() + cOut.getSuit() + " To Seq Stack " + (j2 + 1));
            }
            cOut.setLegal(true);
            while (!curr.isEmpty()) {
                src.push(curr.pop());
            }
            return;
        }
        while (!curr.isEmpty()) {
            src.push(curr.pop());
        }
    }

    public GameState(GameInfo gameInfo, ClassicDeck deck, Stack revealedCards, SolitaireStack[] solStack, SequentialStack[] seqStack, Stack src, Stack dst, Stack curr) {
        ClassicCard c;
        ClassicCard currentCard;
        ClassicCard c2;
        ClassicCard currentCard2;
        int i;
        this.gameInfo = new GameInfo(gameInfo.getType(), gameInfo.getSeed());
        this.deck = new ClassicDeck();
        for (i = 0; i < deck.cardCount(); ++i) {
            currentCard2 = (ClassicCard)deck.elementAt(i);
            c2 = new ClassicCard(currentCard2);
            this.deck.push(c2);
        }
        this.revealedCards = new Stack();
        for (i = 0; i < revealedCards.cardCount(); ++i) {
            currentCard2 = (ClassicCard)revealedCards.elementAt(i);
            c2 = new ClassicCard(currentCard2);
            this.revealedCards.push(c2);
        }
        this.solStack = new SolitaireStack[7];
        for (i = 0; i < 7; ++i) {
            this.solStack[i] = new SolitaireStack();
            for (int j = 0; j < solStack[i].cardCount(); ++j) {
                currentCard = (ClassicCard)solStack[i].elementAt(j);
                c = new ClassicCard(currentCard);
                this.solStack[i].push(c);
            }
        }
        this.seqStack = new SequentialStack[4];
        for (i = 0; i < 4; ++i) {
            this.seqStack[i] = new SequentialStack();
            for (int j = 0; j < seqStack[i].cardCount(); ++j) {
                currentCard = (ClassicCard)seqStack[i].elementAt(j);
                c = new ClassicCard(currentCard);
                this.seqStack[i].push(c);
            }
        }
        this.src = src;
        this.dst = dst;
        this.curr = curr;
    }

    public GameState(GameInfo gameInfo, ClassicDeck deck, Stack revealedCards, SolitaireStack[] solStack, SequentialStack[] seqStack) {
        this.gameInfo = gameInfo;
        this.deck = deck;
        this.revealedCards = revealedCards;
        this.solStack = solStack;
        this.seqStack = seqStack;
    }

    public void restoreGameState(GameInfo gameInfo, ClassicDeck deck, Stack revealedCards, SolitaireStack[] solStack, SequentialStack[] seqStack, Move move) {
        ClassicCard c;
        ClassicCard currentCard;
        ClassicCard c2;
        ClassicCard currentCard2;
        int i;
        gameInfo.setType(this.gameInfo.getType());
        gameInfo.setSeed(this.gameInfo.getSeed());
        while (!revealedCards.isEmpty()) {
            revealedCards.pop();
        }
        for (i = 0; i < this.revealedCards.cardCount(); ++i) {
            currentCard2 = (ClassicCard)this.revealedCards.elementAt(i);
            c2 = new ClassicCard(currentCard2);
            revealedCards.push(c2);
        }
        while (!deck.isEmpty()) {
            deck.pop();
        }
        for (i = 0; i < this.deck.cardCount(); ++i) {
            currentCard2 = (ClassicCard)this.deck.elementAt(i);
            c2 = new ClassicCard(currentCard2);
            deck.push(c2);
        }
        for (i = 0; i < 4; ++i) {
            while (!seqStack[i].isEmpty()) {
                seqStack[i].pop();
            }
            for (int j = 0; j < this.seqStack[i].cardCount(); ++j) {
                currentCard = (ClassicCard)this.seqStack[i].elementAt(j);
                c = new ClassicCard(currentCard);
                seqStack[i].push(c);
            }
        }
        for (i = 0; i < 7; ++i) {
            while (!solStack[i].isEmpty()) {
                solStack[i].pop();
            }
            for (int j = 0; j < this.solStack[i].cardCount(); ++j) {
                currentCard = (ClassicCard)this.solStack[i].elementAt(j);
                c = new ClassicCard(currentCard);
                solStack[i].push(c);
            }
        }
    }

    public String toString() {
        return this.gameInfo.toString();
    }
}

