/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class ImagePanel
extends Panel {
    private boolean isDoubleBuffered;
    private boolean isImgLoaded;
    private Image img;
    private Image offscreen;
    private Graphics offscreenGr;

    public ImagePanel() {
    }

    public ImagePanel(Image image) {
        this.setImage(image);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.img == null) {
            return super.getPreferredSize();
        }
        int width = this.img.getWidth(this);
        int height = this.img.getHeight(this);
        return new Dimension(width, height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.offscreen != null) {
            this.offscreenGr.dispose();
            this.offscreen = null;
            this.offscreenGr = null;
        }
        super.setBounds(x, y, width, height);
    }

    public void setImage(Image image) {
        this.img = image;
        this.isImgLoaded = false;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        if (!this.isDoubleBuffered) {
            this.paint(g);
            return;
        }
        Dimension dim = this.getSize();
        if (this.offscreen == null) {
            this.offscreen = this.createImage(dim.width, dim.height);
            this.offscreenGr = this.offscreen.getGraphics();
        }
        this.paint(this.offscreenGr);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.img == null) {
            return;
        }
        if (!this.prepareImage(this.img, this)) {
            String str = "Loading image...";
            FontMetrics fm = this.getFontMetrics(this.getFont());
            Dimension dim = this.getSize();
            int x = (dim.width - fm.stringWidth(str)) / 2;
            int y = (dim.height - fm.getHeight()) / 2;
            g.drawString(str, x, y);
            return;
        }
        this.isImgLoaded = true;
        Dimension dim = this.getSize();
        int imgWidth = this.img.getWidth(this);
        int imgHeight = this.img.getHeight(this);
        int x = (dim.width - imgWidth) / 2;
        int y = (dim.height - imgHeight) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        g.drawImage(this.img, x, y, this);
    }

    public boolean isImageLoaded() {
        return this.isImgLoaded;
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.isDoubleBuffered;
    }

    public void setDoubleBuffered(boolean isDoubleBuffered) {
        this.repaint();
    }

    public void destroy() {
        if (this.offscreenGr != null) {
            this.offscreenGr.dispose();
        }
    }
}

