/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.util;

import com.sixlegs.image.png.PngImage;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Util {
    public static Image getImageResourceFile(String strResourceFilename, Class srcClass) {
        PngImage pngImage = null;
        Image image = null;
        try {
            BufferedInputStream in = new BufferedInputStream(srcClass.getResourceAsStream(strResourceFilename));
            if (in == null) {
                System.err.println("Image not found:" + strResourceFilename);
                return null;
            }
            if (strResourceFilename.endsWith(".png")) {
                pngImage = new PngImage(in);
                image = Toolkit.getDefaultToolkit().createImage(pngImage);
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Util.copy(in, out);
                image = Toolkit.getDefaultToolkit().createImage(out.toByteArray());
            }
        }
        catch (IOException e) {
            System.err.println("Unable to read image " + strResourceFilename + ".");
            e.printStackTrace();
        }
        return image;
    }

    public static void loadImages(Image[] images, Component comp) {
        MediaTracker tracker = new MediaTracker(comp);
        for (int i = 0; i < images.length; ++i) {
            tracker.addImage(images[i], 0);
        }
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }
}

