/*****************************************************************************\
* NEWLOOK.CMD - main procedure                                                *
\*****************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
'@echo off'
'ECHO [47;31m'
'cls'

/*****************************************************************************\
*  Error checking: working directory, RC.EXE, RCPP.EXE, RCPP.ERR, RDC.CMD,    *
*                  RESMGR.CMD, RDCPP.EXE, SYSICONS and WINCTLS subdirectoties *
*                  free drive space, command processor                        *
\*****************************************************************************/

/* check working directory                                                   */
wkdir = SysSearchPath('PATH', 'NEWLOOK.CMD')
if wkdir = '' then do
   call startMsg
   say '  NEWLOOK.CMD must be run in its own directory. Just double click on its icon.'
   call endMsg
end

/* look for RC.EXE, RCPP.EXE and RCPP.ERR                                    */
rcpath = SysSearchPath('PATH', 'RC.EXE')
rcpppath = SysSearchPath('PATH', 'RCPP.EXE')
rcppErrpath = SysSearchPath('PATH', 'RCPP.ERR')
if (rcpath = '' | rcpppath = '' | rcppErrpath = '') then do
   call startMsg
   say '  You must install RC.EXE, RCPP.EXE and RCPP.ERR in a directory included in'
   say '  the PATH statement of your CONFIG.SYS. See NEWLOOK.TXT for more details.'
   call SysCurPos 15, 2
   call endMsg
end

/* look for Martin Lafaix's RESMGR                                           */
rdcpath = SysSearchPath('PATH', 'RDC.CMD')
resmgrpath = SysSearchPath('PATH', 'RESMGR.CMD')
rdcpppath = SysSearchPath('PATH', 'RDCPP.EXE')
nldir = DIRECTORY()
if (rdcpath = '' | resmgrpath = '' | rdcpppath = '') then do
   call startMsg
   say '  You must install Martin Lafaix''s RESMGR in...'
   say '  'nldir
   say '  or any other directory included in the PATH statement of your CONFIG.SYS.'
   say '  See NEWLOOK.TXT for more details.'
   call endMsg
end

/* check the existence of SYSICONS and WINCTLS directories                   */
nlIcoDir=STREAM(nldir || '\SYSICONS\PMWP.RC','C','QUERY EXISTS')
nlWCTLsDir=STREAM(nldir || '\WINCTLS\PMMERGE.RC','C','QUERY EXISTS')
if (nlIcoDir = '' | nlWCTLsDir = '') then do
   call startMsg
   say '  Cannot find SYSICONS or WINCTLS subdirectories!!!'
   say '  When extracting NEWLOOK.ZIP you must rebuild SYSICONS and WINCTLS'
   say '  subdirectories. Do not use UNZIP with the ''-j'' option!'
   call endMsg
end

/* check if there is enough space on the disk                                */
nldrive=filespec('drive', nldir)
parse value SysDriveInfo(nldrive) with a freespace b c
freespace=trunc(freespace/1048576,1)
pmwpSav = STREAM(nldir || '\PMWP.SAV', 'C', 'QUERY EXISTS')
pmmergeSav = STREAM(nldir ||'\PMMERGE.SAV', 'C', 'QUERY EXISTS')
select
   when (freespace < 3 & (pmwpSav = '' | pmmergeSav = ''))
      then do
      call startMsg
      say '  you have only' freespace 'Mb of free disk space on drive' nldrive
      say '  you need at least 3 Mb.'
      say '  Type ''read'' in the menu screen to see NEWLOOK.TXT for more details.'
      call endMsg 'noexit'
      end
   when (freespace < 6 | (freespace < 3 & pmwpSav \= ''  & pmmergeSav \= ''))
      then do
      call startMsg
      say '  you have only' freespace 'Mb of free disk space on drive' nldrive
      say '  you need at least 6 Mb to run the ''newall'' COMMAND or make more'
      say '  than one back-up copy of PMWP.DLL and PMMERGE.DLL. If you want to'
      say '  change both icons and window controls, change the first before, then'
      say '  reboot, change the controls and then reboot again.'
      say '  Type ''read'' in the menu screen to see NEWLOOK.TXT for more details.'
      call endMsg 'noexit'
      end
   when (freespace < 8 & pmwpSav = '' & pmmergeSav = '')
      then do
      call startMsg
      say '  you have only' freespace 'Mb of free disk space on drive' nldrive '.'
      say '  You need at least 8 Mb to make more than one back-up copy of'
      say '  PMWP.DLL and PMMERGE.DLL. Copy PMWP.SAV and PMMERGE.SAV on diskettes'
      say '  and delete the originals if you have just installed an OS/2 FixPack'
      say '  and want to patch the new PMMERGE.DLL and PMWP.DLL.'
      say '  Type ''read'' in the menu screen to see NEWLOOK.TXT for more details.'
      call endMsg 'noexit'
      end
   otherwise
      nop
end

/* look for CMD.EXE                                                          */
cmdpath = SysSearchPath('PATH', 'CMD.EXE')
if cmdpath = '' then do
   call startMsg
   say '  cannot find CMD.EXE. If you use a different command processor you must'
   say '  reinstall CMD.EXE or edit NEWLOOK.CMD file, replacing all CMD.EXE'
   say '  occurrencies with the name of the executable of your command processor.'
   call endMsg
end

/* gets OS/2 drive and directory                                             */
os2drive = FILESPEC('drive', cmdpath)
os2path = FILESPEC('path', cmdpath)

/* introduction screen                                                       */
say '[47m'
'cls'
say
say '  [37;1m [30m'
say '  [37;1m  [40;31;1m                                                                      [47;30m '
say '  [37;1m  [40;31;1m   *****************       NEWLOOK V. 0.11       ******************   [47;30m '
say '  [37;1m  [40;31;1m   March 28 1996            copyright (c)      Alessandro Cantatore   [47;30m '
say '  [37;1m  [40;31;1m                                                                      [47;30m '
say '  [37;1m [47;30m'
say
say '  [37;1m [30m'
say '  [37;1m  [40;31;1m                                                                      [47;30m '
say '  [37;1m  [40;32;1m       If you decide to change the default system icons or window     [47;30m '
say '  [37;1m  [40;32;1m     controls, PMWP.DLL and / or PMMERGE.DLL will be changed. The     [47;30m '
say '  [37;1m  [40;32;1m     original files will be copied  as PMWP. SAV and PMMERGE. SAV     [47;30m '
say '  [37;1m  [40;32;1m     in NEWLOOK directory .  Your CONFIG. SYS will be temporarily     [47;30m '
say '  [37;1m  [40;32;1m     changed too and a back-up copy will be saved as CONFIG.NLK.      [47;30m '
say '  [37;1m  [40;32;1m       If you ever used RESMGR  or CHG_CTLS application, you must     [47;30m '
say '  [37;1m  [40;32;1m     restore the original DLLs before applying new default system     [47;30m '
say '  [37;1m  [40;32;1m     icons or window controls.                                        [47;30m '
say '  [37;1m  [40;32;1m       Type READ in the following menu screen for more details.       [47;30m '
say '  [37;1m  [40;31;1m                                                                      [47;30m '
say '  [37;1m [47;30m'
call SysCurPos 23, 4
'pause'
call mainmenu
call SysDropFuncs
exit


/*****************************************************************************\
*  mainmenu: menu procedure                                                   *
\*****************************************************************************/

mainmenu:
   say '[47m'
   'cls'
   call SysCurPos 2, 0
   say '  [37;1m [30m'
   say '  [37;1m  [40;31;1m                                                                      [47;30m '
   say '  [37;1m  [40;31;1m   ACTION                                                  COMMAND    [47;30m '
   say '  [37;1m  [40;32;1m   Read NEWLOOK.TXT ...................................... read       [47;30m '
   say '  [37;1m  [40;32;1m   Edit the new system icons ............................. editico    [47;30m '
   say '  [37;1m  [40;32;1m   Edit the new window controls .......................... editctls   [47;30m '
   say '  [37;1m  [40;32;1m   Change the default system icons ....................... newico     [47;30m '
   say '  [37;1m  [40;32;1m   Change window controls ................................ newctls    [47;30m '
   say '  [37;1m  [40;32;1m   Change both system icon and window controls ........... newall     [47;30m '
   say '  [37;1m  [40;32;1m   Restore original system icons ......................... restico    [47;30m '
   say '  [37;1m  [40;32;1m   Restore original window controls ...................... restctls   [47;30m '
   say '  [37;1m  [40;32;1m   Restore both original system icons and window controls  restall    [47;30m '
   say '  [37;1m  [40;32;1m   Exit .................................................. quit       [47;30m '
   say '  [37;1m  [40;31;1m                                                                      [47;30m '
   say '  [37;1m [47;30m'

   say '[34m'
   call SysCurPos 18, 0
   say '  [37;1m [30m'
   say '  [37;1m  [40m                                                                      [47;30m '
   say '  [37;1m  [40m                                                                      [47;30m '
   say '  [37;1m  [40m                                                                      [47;30m '
   say '  [37;1m [47;30m'
   do while done \= 1
      call SysCurPos 20, 8
      say '[40;32;1m                                                          '
      call SysCurPos 20, 8
      pull action
      say '[47;34m'
      select
         when action = 'READ'          /* read program documentation         */
            then do
               call readdoc
               call mainmenu
               done = 1
            end
         when action = 'EDITICO'       /* open SYSICONS folder for editing   */
            then do
               call editing 'SYSICONS'
               call mainmenu
               done = 1
            end
         when action = 'EDITCTLS'      /* open WINCTLS folder for editing    */
            then do
               call editing 'WINCTLS'
               call mainmenu
               done = 1
            end
         when action = 'NEWICO'        /* patch PMWP.DLL                     */
            then do
               call patchdll 'PMWP'
               call doneMsg
               done = 1
            end
         when action = 'NEWCTLS'       /* patch PMMERGE.DLL                  */
            then do
               call patchdll , 'PMMERGE'
               call doneMsg
               done = 1
            end
         when action = 'NEWALL'        /* patch both PMWP.DLL and PMMERGE.DLL*/
            then do
               call patchdll 'PMWP', 'PMMERGE'
               call doneMsg
               done = 1
            end
         when action = 'RESTICO'       /* restore original PMWP.DLL          */
            then do
               call restore 'PMWP'
               call doneMsg
               done = 1
            end
         when action = 'RESTCTLS'      /* restore original PMMERGE.DLL       */
            then do
               call restore , 'PMMERGE'
               call doneMsg
               done = 1
            end
         when action = 'RESTALL'       /* restore original PMWP and PMMERGE  */
            then do
               call restore 'PMWP', 'PMMERGE'
               call doneMsg
               done = 1
            end
         when action = 'QUIT'          /* terminate NEWLOOK.CMD and exit     */
            then do
               call SysDropFuncs
               exit
            end
         otherwise                     /* unvalid command: alarm and loop    */
            call alarm
      end                              /* end select                         */
   end                                 /* end do                             */
return


/*****************************************************************************\
*  readdoc: shows the program documentation                                   *
\*****************************************************************************/

readdoc: procedure
   read = checkEditor('E.EXE')
   read NEWLOOK.TXT
return


/*****************************************************************************\
*  editing: opens "SYSICONS" or "WINCTLS" folder for editing                  *
\*****************************************************************************/

editing: procedure expose nldir
arg folder
   call startMsg
   say '  Now the' folder 'folder will be opened.'
   say '  Icons are saved with a PTR extension. Do not rename them!'
   say '  Icons and Bitmaps are saved in various formats. Remember to check all'
   say '  the available formats by the "Device | List... | View" menu commands.'
   say '  See NEWLOOK.TXT for more details.'
   call endMsg 'noexit'
   rc = SysOpenObject(nldir || '\' || folder, 'default', 'FALSE')
   if rc = 0 then do
      call startMsg
      say '  Cannot open ' nldir || '\' || folder
      call endMsg
   end
return


/*****************************************************************************\
*  doneMsg: after patching DDLs says you must reboot                          *
\*****************************************************************************/

doneMsg:
   call startMsg
   say '  Your system files have been updated.'
   say '  You must reboot in order to let changes take into effect'
   call endsnd
   call endMsg
return


/*****************************************************************************\
*  patchdll: back-ups DLLs passed as arguments, patches them, patches         *
*            CONFIG.SYS and swaps old DLLs with new ones on next reboot       *
\*****************************************************************************/

patchdll: procedure expose os2drive os2path cmdpath nldir
arg name1, name2
   'cls'
   say
   call checkConfig
    /* back-up config.sys                 */
   'copy' os2drive || '\CONFIG.SYS' os2drive || '\CONFIG.NLK'
   'del' os2drive || '\CONFIG.SYS'
   if name1 = ''
      then nop
   else do                             /* PMWP.DLL                           */
      call checkbackup name1, 'PATCH'
      filename = checkdll(name1)
      'copy' filename
      'copy PMWP.DLL PMWP.SAV'
      'rc -r SYSICONS\PMWP.RC'
      if RC \= 0 then
         call patchError 'Resource Compiler', 'PMWP.DLL'
      ADDRESS CMD 'call resmgr -a PMWP.DLL SYSICONS\PMWP.RES'
      if RC \= 0 then
         call patchError 'Resource Manager', 'PMWP.DLL'
      ' del SYSICONS\PMWP.RES'
      'echo call=' || cmdpath '/c copy' nldir || '\PMWP.DLL' os2drive || os2path,
                   || 'DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' nldir || '\PMWP.DLL >>' os2drive,
                   || '\config.sys'
   end
   if name2 = ''
      then nop
   else do                             /* PMMERGE.DLL                        */
      call checkbackup name2, 'PATCH'
      filename = checkdll(name2)
      'copy' filename
      'copy PMMERGE.DLL PMMERGE.SAV'
      'rc -r WINCTLS\PMMERGE.RC'
      if RC \= 0 then
         call patchError 'Resource Compiler', 'PMMERGE.DLL'
      ADDRESS CMD 'call resmgr -a PMMERGE.DLL WINCTLS\PMMERGE.RES'
      if RC \= 0 then
         call patchError 'Resource Manager', 'PMMERGE.DLL'
      'del WINCTLS\PMMERGE.RES'
      'echo call='|| cmdpath '/c copy' nldir || '\PMMERGE.DLL' os2drive || os2path,
                  || 'DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' nldir || '\PMMERGE.DLL >>' os2drive,
                   || '\config.sys'
   end
   'type' os2drive || '\CONFIG.NLK >>' os2drive || '\CONFIG.SYS'
   'echo call=' || cmdpath '/c copy' os2drive || '\CONFIG.NLK' os2drive,
                || '\CONFIG.SYS >>' os2drive || '\CONFIG.SYS'
return


/*****************************************************************************\
*  checkConfig: avoid to overwrite a valid copy of CONFIG.SYS                 *
\*****************************************************************************/

checkConfig:
   'type' os2drive || '\config.sys | find /I "PMWP" >nul'
   if RC = 0 then
      call configError
   'type' os2drive || '\config.sys | find /I "PMMERGE" >nul'
   if RC = 0 then
      call configError
return


/*****************************************************************************\
*  checkdll: checks PMWP.DLL or PMMERGE.DLL existence                         *
\*****************************************************************************/

checkdll: procedure expose os2drive os2path
arg dllname
   filename = stream( os2drive || os2path || '\DLL\' || dllname || '.DLL', 'C',,
                     'query exists')
   if filename = '' then do
      call startMsg
      say '  Cannot find ' dllname || '.DLL in ' os2drive || os2path,
             || '\DLL directory'
      'rename ' os2drive || '\CONFIG.NLK CONFIG.SYS'
      call endMsg
   end
return filename


/*****************************************************************************\
*  restore: restore back-up copies of original DLLs                           *
\*****************************************************************************/

restore: procedure expose os2drive os2path cmdpath nldir
arg name1, name2
   'cls'
   say
   call checkConfig
   'copy' os2drive || '\CONFIG.SYS' os2drive || '\CONFIG.NLK'
   'del' os2drive || '\CONFIG.SYS'     /* back-up config.sys                 */
   if name1 = ''
      then nop
   else do                             /* PMWP.DLL                           */
      filename = checkbackup(name1, 'RESTORE')
      'echo call=' || cmdpath '/c copy' filename os2drive || os2path,
                  || 'DLL\PMWP.DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' filename '>>' os2drive || '\CONFIG.SYS'
   end
   if name2 = ''
      then nop
   else do                             /* PMMERGE.DLL                        */
      filename = checkbackup(name2, 'RESTORE')
      'echo call=' || cmdpath '/c copy' filename os2drive || os2path,
                  || 'DLL\PMMERGE.DLL >>' os2drive || '\CONFIG.SYS'
      'echo call=' || cmdpath '/c del' filename '>>' os2drive || '\CONFIG.SYS'
   end
   'type' os2drive || '\CONFIG.NLK >>' os2drive || '\CONFIG.SYS'
   'echo call=' || cmdpath '/c copy' os2drive || '\CONFIG.NLK' os2drive,
                || '\CONFIG.SYS >>' os2drive || '\CONFIG.SYS'
return


/*****************************************************************************\
*  checkbackup: checks the existence of original back-up copies of PMWP.DLL   *
*  or PMMERGE.DLL                                                             *
\*****************************************************************************/

checkbackup: procedure expose os2drive os2path cmdpath nldir
arg dllname, action
   filename = stream( nldir || '\' || dllname || '.SAV', 'C', 'query exists')
   select
      when (filename = '' & action = 'RESTORE')
         then do
            call startMsg
            say '  Cannot find back-up copy of' dllname || '.DLL in ' nldir || 'directory!'
            say '  You must copy the original from the installation disk renaming it'
            say ' ' dllname || '.SAV and run NEWLOOK again.'
            call undo
         call endMsg
         end
      when (filename \= '' & action = 'PATCH')
         then do
            call startMsg
            say '  NEWLOOK has detected a back-up copy of' dllname || '.DLL .'
            say '  Since RESMGR does not work correctly when re-patching DLLs,'
            say '  you must restore original OS/2 DLLs before patching them.'
            say '  Anyway if you have just installed an OS/2 fixpack, overwriting so'
            say '  previously patched DLLs, you can patch the new DLLs now. In this'
            say '  case' dllname || '.SAV will be saved as' dllname || '.SV1.'
            say '  If later you make a back-out of the FixPack do not forget to delete'
            say ' ' dllname || '.SAV and to rename' dllname || '.SV1' dllname || '.SAV.'
            say '  Type "continue" to patch DLLs now, press "enter" to go back to mainmenu.'
            say '  See NEWLOOK.TXT for more details.'
            pull reply
            if reply = 'CONTINUE' then
               return filename
            else do
               call undo
               call mainmenu
            end
         end
      otherwise
         nop
   end
return filename


/*****************************************************************************\
*  checkEditor: if it cannot find e.exe in the CONFIG.SYS PATH asks the user  *
*               for another editor                                            *
\*****************************************************************************/

checkEditor: procedure
arg editor
   editpath = SysSearchPath('PATH', editor)
   if editpath = '' then do
      call startMsg
      say '  Cannot find' editor || '.'
      say '  Type the name of the executable file of the editor you use.'
      say
      pull editor
      exestension = right(editor, 3)
      if exestension \= 'EXE' then
      editor = editor ||'.exe'
      editor = checkEditor(editor)
   end
return editor


/*****************************************************************************\
*  configError: restore a back-up copy of CONFIG.SYS, if cannot find          *
*  CONFIG.NLK strips CONFIG.SYS of all "call=x:\os2\cmd.exe..." statements    *
\*****************************************************************************/

configError: procedure expose os2drive os2path cmdpath nldir
   call startMsg
   say '  Error!!! You did not reboot after patching the DLL!!!'
   say '  NEWLOOK will restore the original files. Do not press Ctrl+C or'
   say '  Ctrl-break now!!! See NEWLOOK.TXT for more details.'
   say
   'pause'
   say
   RC = undo()
   if RC \= 0 then do
      call alarm
      say '  You deleted the back-up copy of CONFIG.SYS!!!'
      say '  NEWLOOK will try to rebuild it now.'
      say '  Please check the new CONFIG.SYS file!!!'
      say '  A copy of the wrong CONFIG.SYS will be saved as CONFIG.ERR'
      say
      'pause'
      say
      'copy' os2drive '\config.sys' os2drive '\config.err'
      'type' os2drive '\config.err | find /I /V "call=' || cmdpath || '" > config.sys'
      read = checkEditor('E.EXE')
      read  os2drive '\config.sys'
   end
   call startMsg
   say '  Everything has been restored to its previous state as you'
   say '  had never run NEWLOOK since last reboot.'
   say '  Now if you still want to change or restore icons or controls'
   say '  run again NEWLOOK, type the proper command and then reboot.'
   call endsnd
   call endMsg
   call SysDropFuncs
   exit
return


/*****************************************************************************\
*  compareDLL : compares *.DLL with *.SAV if they have same size and same     *
*               time stamp returns 1                                          *
\*****************************************************************************/

compareDLL: procedure expose os2drive os2path nldir
arg DLLname
   call SysFileTree os2drive || os2path || 'DLL\' || DLLname || '.DLL', filename, 'T'
   DLLfile=left(filename.1, 26)
   call SysFileTree nldir || '\' || DLLname || '.SAV', filename, 'T'
   SAVfile=left(filename.1, 26)
return DLLfile=SAVfile


/*****************************************************************************\
*  undo : cleans NEWLOOK directory in case of failure                         *
\*****************************************************************************/

undo: procedure expose os2drive os2path nldir
   RC = compareDLL('PMWP')
   if RC = 1 then
      call SysFileDelete nldir || '\PMWP.SAV'
   call SysFileDelete nldir || '\PMWP.DLL'
   RC = compareDLL('PMMERGE')
   if RC = 1 then
      call SysFileDelete nldir || '\PMMERGE.SAV'
   call SysFileDelete nldir || '\PMMERGE.DLL'
   'copy' os2drive || '\config.nlk' os2drive || '\config.sys'
return RC


/*****************************************************************************\
*  patchError: show a message in case of failure of RC or RESMGR              *
\*****************************************************************************/

patchError: procedure
arg command, dllfile
   call startMsg
   say ' ' command 'error while patching' dllfile || '!!!'
   say '  See NEWLOOK.TXT for more details!'
   call undo
   call endMsg
return


alarm:
  call beep 1000,300
  call beep 150, 500
return


endsnd:
  call beep 1600, 200
  call beep 800, 200
  call beep 400, 200
  call beep 200, 200
  call beep 100, 200
return


startMsg:
   'cls'
   call alarm
   call SysCurPos 5, 0
return


endMsg: procedure
arg done
   call SysCurPos 19, 2
   'pause'
   if done = '' then do
      call SysDropFuncs
      exit
   end
return


