/* George W. Barrowcliff       73324,2541                                *
*  9/29/96  Version 1.0                                                  *
*  This program resets the system clock at 2AM on October 27th, 1996     *
*  It also writes a line in the IPL.LOG located in the C:\MISC directory *
*     Daylight Savings Time Starts at 2AM on the First Sunday in April   *
*                          and ends at 2AM on the last Sunday in October *
*  It is left to the interested student to rework this program for       *
*  The first Sunday in April, 1997 (Day 96), or to be year independant   */

/*  A companion program called DSTADD.CMD will add the program to the    *
*   Startup Folder, so it will always load when the system is booted     */

debug=0
IPLLog='C:\misc\ipl.log'
Marker='DST-Fall'||Right(Date('N'),4)    /* DST-Fall1996 */
Call RxFuncAdd 'RexxLibRegister','SysSleep','RexxLibRegister'  /* Will be needing this later */
MinsDay=60*24
SecsDay=MinsDay*60                 /* Seconds in a day for sleeping  */
SecsHour=60*60                     /* Seconds in an Hour  */
DSTday=301                         /* 10/27/96  Fall Back */
Do Debug
  DSTDay=Date('D') + 1             /*   Make it tomorrow for testing  */
end /* do */
                                   /*  If not already done .....  else quit   */
Do while lines(IPLLog) > 0
   If Left(linein(IPLLog),Length(Marker))=Marker then  Exit /*  Already been set this year  */
end /* do */
rc=Lineout(IPLLog)                 /*  Close log file  */

MinToMid=MinsDay - time("M")       /*  Minutes until tomorrow  */
DaysThisYear=Date("D") +1          /*  at midnight it will be tomorrow   */
do debug
 trace r
 rc=Time('N')  /* What time is it Now?  */
end /* do */
WaitTime= (DSTday-DaysThisYear)*1440 + MinToMid  + 120   /* Reset at 2AM  */
DaysWaiting=WaitTime % MinsDay
HoursToWait=(WaitTime // MinsDay) % 60
MinsToWait=(WaitTime // MinsDay) // 60
If DaysWaiting<0 | HoursToWait<0 | MinsToWait<0 then  Exit   /* Time already gone by  */
  /*  Now the Waiting Starts  */   /* First wait out this hour           */
Call SysSleep(MinsToWait*60)       /*  Must have an Int for an argument  */
Call SysSleep(HoursToWait*SecsHour) /* Wait now until 2 AM tomorrow       */

Do DaysWaiting                     /*  Wait out the days until X time    */
   Call SysSleep(SecsDay)          /* Those also serve that sit and wait */
end /* do */
Do Debug
   Say Time('N')
end /* do */
/*  Should be 2:00 AM, Sunday Morning, October 27.  Time to Fall Back an hour  */
Now=Time("M")-60                   /* Current time less an hour          */
Now=Now%60||':'||Now//60
/*     Issue the Command line text to reset the time.  */
'Time' Now
/*  Time Reset, now keep it from happening again this year */
Marker=Marker Time('N') Date('W') Date('N')   /* DST-Fall1996 02:01:41 Sunday 27 October 1996  */
rc=Lineout(IPLLog,Marker)
rc=Lineout(IPLLog)
return
